HiredHelperTool = {};

HiredHelperTool.metadata = {
	interface = "FS25 ...", --convert ls22 to ls 25
	title = "HiredHelper Tool",
	notes = "Neue Helfer im SP/MP/DetiServer mit Realen Namen und Helferlimit auf 30 erhöht.",
	author = "(by HappyLooser)",	
	version = "1.0.0.2",	
	build = 60,
	datum = "28.12.2014",
	update = "05.01.2026",
	discord = "HappyLooser Modding",
	info = "Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
}

HiredHelperTool.modDir = g_currentModDirectory;
HiredHelperTool.settingsDir = getUserProfileAppPath().. "modSettings/FS25_HiredHelperTool/";
HiredHelperTool.debugPrint = true;
	
function HiredHelperTool:loadMap(name)	
	HiredHelperTool.errorTable = false;	
	generateFolders();
	if g_currentMission.hiredHelperMapTool ~= nil then HiredHelperTool.errorTable=true;print(tostring(HiredHelperTool.metadata.title).. " Warning: Mod already exists over Map (HiredHelperMapTool). Ignore Mod !");return;end;
	g_currentMission.hiredHelperTool = HiredHelperTool;
	print("---loading ".. tostring(HiredHelperTool.metadata.title).. " ".. tostring(HiredHelperTool.metadata.version).. "(#".. tostring(HiredHelperTool.metadata.build).. ") ".. tostring(HiredHelperTool.metadata.author).. "---")	
	local oldMaxNumHirables = g_currentMission.maxNumHirables;	
	
	--old table--
	local replaceDefaultNames = 0;	
	local helperName = {
		"SALLY";
		"SAM";
		"SCHURA";
		"ZENZ";
		"VIVIAN";
		"REINKE";
		"MAREN";
		"NICKI";
		"LU";
		"FIETE";
		--1-10 replace default names A B C D etc.
		"CATO";
		"CURLY"; 
		"FRANA";
		"FRIIS";
		"IKE";
		"JULES";
		"SANJA";
		"MIKA";
		"APKE";
		"JOYCE";
		
		"ELISA";
		"KAYA";
		"IMRE";
		"JACKY";
		"EIKE";
		"NAT";
		"PATTY";
		"TAM";
		"TADE";
		"TEDE"; --default 30, max 50 etc. etc. to Big = Performenc a Server or/and Client collapse
	};
	--old table--
	if g_currentMission ~= nil and HelperManager ~= nil and g_helperManager ~= nil then 					
		local Xml = nil;
		local XmlExtern = nil;
		if not g_currentMission.missionDynamicInfo.isMultiplayer and fileExists(HiredHelperTool.settingsDir.. "helpers.xml") then
			XmlExtern = loadXMLFile("helpers", HiredHelperTool.settingsDir.. "helpers.xml", "helpersXML"); --prio SP
		end;
		if XmlExtern ~= nil then 
			Xml = XmlExtern;
		else	
			Xml = loadXMLFile("helpers", HiredHelperTool.modDir.. "helpers.xml", "helpersXML");
		end;
		local xmlFile = nil;
		if Xml ~= nil then xmlFile = XMLFile.wrap(Xml, HelperManager.xmlSchema);end;
		if xmlFile ~= nil and Xml ~= nil then			
			function table.removeKey(t, k_to_remove)
			  local new = {};
			  for k, v in pairs(t) do
				new[k] = v;
			  end;
			  new[k_to_remove] = nil;
			  return new;
			end;
			function removeAvailableHelper(helper)
				for k, h in pairs(g_helperManager.availableHelpers) do
					if h == helper then
						table.remove(g_helperManager.availableHelpers, k);						
					end;
				end;				
			end;
			local helperMapNames = {};
			function deleteOldNames()
				for key, value in pairs(g_helperManager.helpers) do					
					if value.name:len() > 1 then table.insert(helperMapNames, value.name);end;
					--if value.name:len() <= 1 then
						local index = value.index;												
						removeAvailableHelper(value);
						g_helperManager.nameToIndex = table.removeKey(g_helperManager.nameToIndex, key);
						g_helperManager.helpers = table.removeKey(g_helperManager.helpers, key);
						g_helperManager.indexToHelper = table.removeKey(g_helperManager.helpers, index);
						--print("del Helper Name: ".. tostring(value.name).. " / ".. tostring(index))
					--end;
				end;
				g_helperManager.numHelpers = #g_helperManager.availableHelpers or 0;
			end;			
			local xmlNameTag = ("map.helpers"):format(0);
			local maxXmlHelpers = getXMLInt(Xml, xmlNameTag.."#limit", 30);
			deleteOldNames();						
			for _, key in xmlFile:iterator("map.helpers.helper") do
				if #g_helperManager.availableHelpers == maxXmlHelpers then break;end;
				local nameByXml = xmlFile:getValue(key .. "#name"):upper();				
				local name = nameByXml;
				if #helperMapNames > 0 then 
					local nameByMap = helperMapNames[1];
					table.remove(helperMapNames, 1);
					if nameByMap == nil or g_helperManager:getHelperByName(nameByMap) == nil then name = nameByMap;end;
				end;
				local title = xmlFile:getValue(key .. "#title", nil, nil, false);
				local color = xmlFile:getValue(key .. "#color", {1, 1, 1});					
				local playerStyle = PlayerStyle.new();
				playerStyle:loadFromXMLFile(xmlFile, key .. ".playerStyle");

				g_helperManager:addHelper(name, title, color, playerStyle, nil, true);
				--print("add Helper Name: ".. tostring(name).. " / ".. tostring(g_helperManager.numHelpers))
			end;
			g_currentMission.maxNumHirables = g_helperManager.numHelpers;
			delete(Xml);
			xmlFile:delete();
		else
			errorTable = true;
		end;			
		if HiredHelperTool.errorTable then print("---Script ".. tostring(HiredHelperTool.metadata.title).. " Error !!!(helperName Table length or XML-File corrupt)---");g_currentMission.maxNumHirables = oldMaxNumHirables;return false;end;
		if g_helperManager.numHelpers < #g_helperManager.availableHelpers then g_helperManager.numHelpers = #g_helperManager.availableHelpers;end;
		print(tostring(HiredHelperTool.metadata.title).. " Info: found ".. tostring(g_helperManager.numHelpers).. " available helpers names");
		--HiredHelperTool:testing();
	else
		HiredHelperTool.errorTable = true;
		print("---Script ".. tostring(HiredHelperTool.metadata.title).. " Error !!!(not found MissionsData/HelperManager)---");
	end;	
end;

function HiredHelperTool:update(dt)	
	if not HiredHelperTool.errorTable then
		if g_currentMission.maxNumHirables ~= g_helperManager.numHelpers then --for secureness
			g_currentMission.maxNumHirables = g_helperManager.numHelpers;						
		end;
	end;
end;
addModEventListener(HiredHelperTool);

function generateFolders()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(getUserProfileAppPath().. "modSettings/FS25_HiredHelperTool/");		
end;

function HiredHelperTool:testing()
	local missingHelper = {};
	for a=1, 30 do
		missingHelper[a] = {helper=a,helperNumber=true,helperStyle=true,helperName=""};
		local helper = g_helperManager.indexToHelper[a];
		if helper == nil then
			missingHelper[a].helperNumber = false;
			missingHelper[a].helperStyle = false;
		else
			local playerStyle = helper.playerStyle;			
			if playerStyle == nil then 
				missingHelper[a].helperStyle = false;
			end;
			missingHelper[a].helperName = helper.name;
		end;		
	end;
	print(DebugUtil.printTableRecursively(missingHelper, "Helpers ", 0, 1))
end;

function orgRandomHelperStyle(superFunc)
    if HiredHelperTool.debugPrint then HiredHelperTool.debugPrint = false;HiredHelperTool:testing();end;
	local randomHelper = math.random(1, g_helperManager.numHelpers);
	local helper = g_helperManager.indexToHelper[randomHelper];
	if helper ~= nil then
		local playerStyle = helper.playerStyle;
		print("numHelpers: ".. tostring(g_helperManager.numHelpers).. "|randomHelper: ".. tostring(randomHelper).. "helperName: ".. tostring(helper.name).. "|helper: true|playerStyle: ".. tostring(playerStyle));
	else
		print("numHelpers: ".. tostring(g_helperManager.numHelpers).. "|randomHelper: ".. tostring(randomHelper).. "helperName: nil|helper: false|playerStyle: not found");
	end;
	return g_helperManager.indexToHelper[randomHelper].playerStyle;
end;
--HelperManager.getRandomHelperStyle = Utils.overwrittenFunction(HelperManager.getRandomHelperStyle, orgRandomHelperStyle);



